package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name="`eventtype`",schema="hib")
public class EventType extends ReferenceObject {

	private static final int EVENT_TYPE_ID_INITIATE_REQUEST			= 1;
	private static final int EVENT_TYPE_ID_SUBMIT_REQUEST			= 2;
	private static final int EVENT_TYPE_ID_AMEND_REQUEST			= 3;
	private static final int EVENT_TYPE_ID_SUBMIT_CHANGE_REQUEST	= 4;	
	private static final int EVENT_TYPE_ID_CLOSE_REQUEST			= 5;
	private static final int EVENT_TYPE_ID_APPROVE_REVIEW			= 6;
	private static final int EVENT_TYPE_ID_DENY_REVIEW				= 7;
	private static final int EVENT_TYPE_ID_CHANGE_REQUEST			= 8;
	private static final int EVENT_TYPE_ID_SENT_FOR_REVIEW			= 9;
	private static final int EVENT_TYPE_ID_APPROVE_WORKFLOW			= 10;
	private static final int EVENT_TYPE_ID_REQUEST_COMPLETED		= 11;
	private static final int EVENT_TYPE_ID_CLOSE_WORKFLOW			= 12;
	private static final int EVENT_TYPE_ID_WITHDRAW_REVIEW          = 13;
	private static final int EVENT_TYPE_ID_CHANGE_REVIEWS           = 14;
	private static final int EVENT_TYPE_ID_PARTICIPANT_ADDED        = 15;
	private static final int EVENT_TYPE_ID_PARTICIPANT_REMOVED      = 16;
			
	public static EventType INITIATE_REQUEST;
	public static EventType SUBMIT_REQUEST;
	public static EventType AMEND_REQUEST;
	public static EventType SUBMIT_CHANGE_REQUEST;
	public static EventType CLOSE_REQUEST;		//close the entire request
	public static EventType APPROVE_REVIEW;		//approve a single review
	public static EventType DENY_REVIEW;
	public static EventType CHANGE_REQUEST;
	public static EventType SENT_FOR_REVIEW;
	public static EventType APPROVE_WORKFLOW;	//approve the workflow
	public static EventType REQUEST_COMPLETED;	//all workflows completed
	public static EventType CLOSE_WORKFLOW;		//workflow closed (data sources removed)
	public static EventType WITHDRAW_REVIEW;
	public static EventType CHANGE_REVIEWS;
	public static EventType PARTICIPANT_ADDED;
	public static EventType PARTICIPANT_REMOVED;
	
	private static boolean initialized = false;
	
	public static void initialize() {
		if (initialized == true) {
			return;
		}
				
		try {
			INITIATE_REQUEST = EventType.findById(EVENT_TYPE_ID_INITIATE_REQUEST);
			SUBMIT_REQUEST = EventType.findById(EVENT_TYPE_ID_SUBMIT_REQUEST);
			AMEND_REQUEST = EventType.findById(EVENT_TYPE_ID_AMEND_REQUEST);
			SUBMIT_CHANGE_REQUEST = EventType.findById(EVENT_TYPE_ID_SUBMIT_CHANGE_REQUEST);
	
			CLOSE_REQUEST = EventType.findById(EVENT_TYPE_ID_CLOSE_REQUEST);
			
			APPROVE_REVIEW = EventType.findById(EVENT_TYPE_ID_APPROVE_REVIEW);
			DENY_REVIEW = EventType.findById(EVENT_TYPE_ID_DENY_REVIEW);
			CHANGE_REQUEST = EventType.findById(EVENT_TYPE_ID_CHANGE_REQUEST);
			SENT_FOR_REVIEW = EventType.findById(EVENT_TYPE_ID_SENT_FOR_REVIEW);
	
			APPROVE_WORKFLOW = EventType.findById(EVENT_TYPE_ID_APPROVE_WORKFLOW);

			REQUEST_COMPLETED = EventType.findById(EVENT_TYPE_ID_REQUEST_COMPLETED);

			CLOSE_WORKFLOW = EventType.findById(EVENT_TYPE_ID_CLOSE_WORKFLOW);
			
			WITHDRAW_REVIEW = EventType.findById(EVENT_TYPE_ID_WITHDRAW_REVIEW);
			
			CHANGE_REVIEWS = EventType.findById(EVENT_TYPE_ID_CHANGE_REVIEWS);

			PARTICIPANT_ADDED = EventType.findById(EVENT_TYPE_ID_PARTICIPANT_ADDED);
			
			PARTICIPANT_REMOVED = EventType.findById(EVENT_TYPE_ID_PARTICIPANT_REMOVED);
			
			initialized = true;	//successfully loaded all of the event types
		}
		catch (ObjectNotFoundException e) {
			e.printStackTrace();
		}
	}
	
	EventType() {}	//default constructor, to avoid the "no default constructor" exception
	
	public EventType( int typeId ) {
		id = typeId;
	}

	
	public static EventType findById(final int eventTypeId) throws ObjectNotFoundException {
		return DartObjectFactory.getInstance().getEventTypeDAO().findById(eventTypeId);
	}
	
	public static List<EventType> listAll() { 
		return DartObjectFactory.getInstance().getEventTypeDAO().listAll();
	}

	
	/**
	 * Returns the event description, with the specified group name, where applicable.
	 * 
	 * @param eventType
	 * @param groupShortName
	 * @return
	 */
	public String getEventDescription( final String groupShortName ) {

		switch( getId() ) {
		
			case EVENT_TYPE_ID_APPROVE_REVIEW:
				return (groupShortName + " Review Approval");
	
			case EVENT_TYPE_ID_DENY_REVIEW:
				return (groupShortName + " Review Denied");
				
			case EVENT_TYPE_ID_CHANGE_REQUEST:
				return ("Change Requested by " + groupShortName);
				
			case EVENT_TYPE_ID_SENT_FOR_REVIEW:
				return ("Request Sent for " + groupShortName + " Review");
						
			//TODO: just retrieve these descriptions from the DB? (no group name used here)
			case EVENT_TYPE_ID_CLOSE_REQUEST:
				return "Data Access Request Closed";

			case EVENT_TYPE_ID_INITIATE_REQUEST:
				return "Initiated Data Access Request";				
				
			case EVENT_TYPE_ID_SUBMIT_REQUEST:
				return "Submitting Data Access Request Packet to NDS";
				
			case EVENT_TYPE_ID_AMEND_REQUEST:
				return "Creating Amendment";	//Event.create("Request Amendment Created", "Creating Amendment", amendmentRequest, prefs.getUserLoginId());
				
			case EVENT_TYPE_ID_SUBMIT_CHANGE_REQUEST:  // Do not use unless you plan to add the group names yourself
				return "Request Submitted with Changes";

			case EVENT_TYPE_ID_APPROVE_WORKFLOW:
			    return groupShortName + " Request Approval"; 	
				
			case EVENT_TYPE_ID_REQUEST_COMPLETED:
				return "Request Completed";

			case EVENT_TYPE_ID_CLOSE_WORKFLOW:
				return "Workflow Closed";
				
			case EVENT_TYPE_ID_WITHDRAW_REVIEW:
			    return ("Request Withdrawn from " + groupShortName + " Review");
			    
			case EVENT_TYPE_ID_CHANGE_REVIEWS:
			    return "Additional Reviews Changed by NDS";
			           
			    
		}
	
		return "";
	}
	
	   /**
     * Returns the event description, with the specified group name, where applicable.
     * 
     * @param eventType
     * @param groupShortName
     * @return
     */
    public String getEventName( final String groupShortName ) {

        switch( getId() ) {
        
            case EVENT_TYPE_ID_APPROVE_REVIEW: //6 - correct  NDS init and NDS Final should not be sent through this
                return (groupShortName + " Review Approval");
    
            case EVENT_TYPE_ID_DENY_REVIEW: 
                return (groupShortName + " Review Denied");
                
            case EVENT_TYPE_ID_CHANGE_REQUEST: 
                return ("Change Requested by " + groupShortName);
                
            case EVENT_TYPE_ID_SENT_FOR_REVIEW:  
                return ("Request Sent for " + groupShortName + " Review");
                        
            case EVENT_TYPE_ID_CLOSE_REQUEST: 
                return "Closed";

            case EVENT_TYPE_ID_INITIATE_REQUEST:
                return "Initiated";             
                
            case EVENT_TYPE_ID_SUBMIT_REQUEST:
                return "Submitted";
                
            case EVENT_TYPE_ID_AMEND_REQUEST: 
                return "Request Amendment Created";  
                
            case EVENT_TYPE_ID_SUBMIT_CHANGE_REQUEST:  //DO NOT USE unless you add group name(s) yourself
                return "Request Submitted with Changes";
                
            case EVENT_TYPE_ID_APPROVE_WORKFLOW: 
                return groupShortName + " Request Approval"; 
                
            case EVENT_TYPE_ID_REQUEST_COMPLETED: 
                return "Request Completed";

            case EVENT_TYPE_ID_CLOSE_WORKFLOW: 
                return "Workflow Closed";
                
            case EVENT_TYPE_ID_WITHDRAW_REVIEW:
                return ("Request Withdrawn from " + groupShortName + " Review");
                
            case EVENT_TYPE_ID_CHANGE_REVIEWS: 
                return "Additional Reviews Changed by NDS";
                       
                
        }
    
        return "";
    }
	
}
